(defun changecontours (surfstyle / ent ss lst x)

(defun AHalloff (surfpick / )
 (foreach surf lst
 (if (= surfpick (car surf))
  (setpropertyvalue (cadr surf) "Visible" -1)
 )
 )
)

(defun AH50 (surfpick / )
 (foreach surf lst
 (if (= surfpick (car surf))
  (progn
   (setpropertyvalue (cadr surf) "Visible" 0)
   (SETPROPERTYVALUE (cadr surf) "Major contours interval" 1.0000)
   (SETPROPERTYVALUE (cadr surf) "Minor contours interval" 0.050)
  )
 )
 )
)

(defun AH100 (surfpick / )
 (foreach surf lst
 (if (= surfpick (car surf))
  (progn
   (setpropertyvalue (cadr surf) "Visible" 0)
   (SETPROPERTYVALUE (cadr surf) "Major contours interval" 1.0000)
   (SETPROPERTYVALUE (cadr surf) "Minor contours interval" 0.10)
  )
 )
 )
)

(defun AH500 (surfpick / )
 (foreach surf lst
 (if (= surfpick (car surf))
  (progn
   (setpropertyvalue (cadr surf) "Visible" 0)
   (SETPROPERTYVALUE (cadr surf) "Major contours interval" 2.5)
   (SETPROPERTYVALUE (cadr surf) "Minor contours interval" 0.50)
  )
 )
 )
)

(defun AH1m (surfpick / )
 (foreach surf lst
 (if (= surfpick (car surf))
  (progn
   (setpropertyvalue (cadr surf) "Visible" 0)
   (SETPROPERTYVALUE (cadr surf) "Major contours interval" 5.0)
   (SETPROPERTYVALUE (cadr surf) "Minor contours interval" 1.0)
  )
 )
 )
)

(defun AHtri (surfpick / )
 (foreach surf lst
 (if (= surfpick (car surf))
  (if (and (= (getpropertyvalue (cadr surf) "Visible") 0) (= (getpropertyvalue (cadr surf) "Triangles") 1))
   (setpropertyvalue (cadr surf) "Triangles" -1)
   (progn
   (setpropertyvalue (cadr surf) "Visible" 0)
   (setpropertyvalue (cadr surf) "Triangles" 1)
  )
 )
 )
 )
)

  ;; Assign new style to selected Civil surfaces
  ;; Required Subroutines: AT:ListSelect
  ;; Alan J. Thompson, 06.22.10
  ;; Modified by Alan H Jan 2011

(vl-load-com)
(if (NOT AT:ListSelect)(load "listselect"))

(setq ss (ssget "X" '((0 . "BsysCvDbTinSurface"))))
(if (= ss nil)
(progn (alert "No surfaces in this dwg \nWill now exit")(exit))
)

(setq lst '() lst2 '())
(Repeat (setq x (sslength ss))
(setq ent (ssname ss (setq x (1- x))))
(setq sname (getpropertyvalue ent "Name" ))
(setq svis (getpropertyvalue ent "Visible" ))
(setq lst (cons (list sname ent svis) lst))
(setq lst2 (cons sname lst2))
)
(setq lst2 (vl-sort lst2 '<))

(cond
((= (length lst) 1)(setq surfacepick  (car (nth 0 lst))))
((progn
  (setq surfacepick (car (AT:ListSelect
    "Set new surface "
    "Select surface name"
    10
    10
    "false"
    lst2
  )))
  )
)
)

(cond 
((= surfstyle "Nothing")(princ "\nNo surfaces active"))
((= surfstyle "alloff")(AHalloff surfacepick))
((= surfstyle "05")(AH50 surfacepick))
((= surfstyle "100")(ah100 surfacepick))
((= surfstyle "200")(ah200 surfacepick))
((= surfstyle "500")(ah500 surfacepick))
((= surfstyle "1m")(ah1m surfacepick))
((= surfstyle "tri")(ahtri surfacepick))
((= surfstyle "slope")(ahslope surfacepick))
)

(princ)  ; exit quietly
)

