///------------------------------------------------------------------------
///		 Layer Creator.dcl v1.9.8
///
///		 Copyright  October2010
///	 		Timothy G. Spangler
///
///		 Permission to use, copy, modify, and distribute this software
///		 for any purpose and without fee is hereby granted, provided
///		 that the above copyright notice appears in all copies and
///		 that both that copyright notice and the limited warranty and
///		 restricted rights notice below appear in all supporting
///		 documentation.
///
///		 Layer Creator:
///				The Layer Creator is a dialog driven program that enables
///				the user to select from differant layer groups to insert
///				standard layers into there drawing.
///------------------------------------------------------------------------
///
/// Main Dialog Box -----------------------------------------------
LayerCreator:dialog{
	label = "Layer Creator v1.9.8";
		:column{
		:row{
			:column{
				:text{
					label = "Layer Groups:";
				}
				:popup_list{						
					key = "layer_group";
					height = 5;
					width = 40;
				}
				:text{
					label = "Layer Names:";
				}
				:list_box{
					key = "lyr_names";
					height = 15;
					width = 40;
					multiple_select = true;
					allow_accept = true;
				}
				spacer_0;
				:row{
					:button{
						label = "Select All";
						key = "selall";
					}
					:button{
						label = "Select None";
						key = "selnone";
					}
				}
				spacer_0;
				:row{
					:toggle{					
						key = "current";
						alignment = left;
						label = "  Make Layer Current";
					}
					:toggle{					
						key = "update";
						alignment = left;
						label = "  Update Layers";
					}
				}				
				:boxed_column{
					label = "Layer Properties";
					spacer_0;
					:text_part{
						key = "layer_name";
						alignment = centered;
					}
					:image{
						key = "sep1";
						color = dialog_background;
						width = 25;
						height = 1;
					}
					spacer_0;
					:row{
						:column{
							:text{
								label = "Color:";
								height = 1;
							}						
							:text{
								label = "Color Number:";
							}
							:text{
								label = "LineType:";
								height = 1;
							}						
							:text{
								label = "LineWeight:";
								height = 1;
							}
							:text{
								label = "Plot:";
								height = 1;
							}
							:text{
								label = "PlotStyle:";
								height = 1;
							}							
						}
						:column{								
							:image_button{
								key = "color";
								width = 4;
								height = 1;
								fixed_width = true;
							}
							:text{
								key = "colorno";
							}
							:text{
								key = "linetype";
							}
							:text{
								key = "linewieght";
							}
							:image{
								key = "plot";
								color = dialog_background;
								width = 5;
								height = 1.5;
								fixed_width = true;
							}
							:text{
								key = "plotstyle";
							}
						}
					}
					:text{
						label = "Description:";
					}	
					:text_part{
						key = "description";
						height = 3;
						alignment = centered;
					}
					spacer_0;
				}
				:boxed_column{
					label = "Plot Properties";					
					:row{
						:column{
							:text{
								label = "Current Plot Style:";
								height = 1;
								key = "pstyletbl";
							}
						}					
					}					
					:radio_row{
						:radio_button{					
							key = "ctb";
							alignment = left;	
							label = "CTB Plotstyles";
						}
						:radio_button{					
							key = "stb";
							alignment = left;
							label = "STB Plotstyles";
						}
					}
					:row{
						:column{
							:text{
								label = "PstyleMode:";
								height = 1;
							}
						}
						:column{
							:text{
								key = "pstylemode";
							}
						}						
					}
					spacer_0;
				}
				insert_cancel_about_export;
				spacer_1;				
			}
		}
		:column{
			:paragraph{
				:text{
					key = "copyright";
					label = "----------  Copyright 2010  ----------";
					alignment = centered;
				}
			}
		}
		spacer_0;
	}
}
/// Layer Group Dialog Box ----------------------------------------------
LayerGroup:dialog{
  label = "Layer Exporter v1.1 ";
	spacer_1;
	:boxed_column{
      label = "Enter Layer Group Name ";
     	:column{
     		:edit_box{
				key = "layer_group";
				width = 40;
				allow_accept = true;
			}
	    spacer_1;     	
		}
	}
	spacer_0;
	ok_cancel;
	:column{
		:paragraph{
			:text{
				key = "copyright";
				label = "----------  Copyright 2010  ----------";
				alignment = centered;
			}
		}
	}
	spacer_0;
}
/// Plot Table Dialog Box ----------------------------------------------
LayerPlotTable:dialog{
  label = "Layer Exporter v1.1 ";
    :boxed_column{
      label = "Select Plot Style Table";
     	:column{
			:list_box{
				key = "table_name";
				height = 15;
				width = 40;
				allow_accept = true;
			}
	      spacer_1; 
		}	  
    }
    spacer_0;
    ok_only;
	:column{
		:paragraph{
			:text{
				key = "copyright";
				label = "----------  Copyright 2010  ----------";
				alignment = centered;
			}
		}
	}
	spacer_0;
}
/// About Dialog Box ----------------------------------------------
LayerCreatorAbout:dialog{
	label = "About Layer Creator v1.9.8";
		:row{
			fixed_width = true;
			:column{
				:image{
					key = "logo";
					color = dialog_background;
					width = 8;
					height = 18;
				}
			}
			:column{
				spacer_1;
				: paragraph{
					: text{
						label = "LAYER CREATOR v1.9.8";
					}
					: text{
						label = "  Copyright  2010";
					}
				}
				:image{
					key = "sep1";
					color = dialog_background;
					width = 20;
					height = 1;
				}
				spacer_1;
				:column{
					:text{
						label = "Written By:";
					}
					spacer_1;
					:row{
						:column{
							:image{
								key = "blank";
								fixed_width = true;
								fixed_height = true;
							}
						}
						:column{
							:text_part{
							label = "Timothy G. Spangler";
							}
							:text_part{
							label = "248 Thomas Drive:";
							}
							:text_part{
							label = "Gettysburg, PA  17325";
							}
						}
					}
					spacer_1;
					:text{
						label = "tim.spangler@gmail.com";
					}		
				}
				spacer_1;
			ok_only;
		}			
	}		
}
// Button Definitions						
							
insert_button : retirement_button {
  key = "insert";
  label = "Insert";
  fixed_width = true;
}
about_button : button {
  key = "about";
  label = "About";
  fixed_width = true;
}
export_button : button {
  key = "export";
  label = "Export";
  fixed_width = true;
}
insert_cancel_about_export:row{
  fixed_width = true;
  alignment = centered;
  insert_button;
  cancel_button;
  about_button;
  export_button;
}

			